<?php
/* --------------------------------------------------------------
   ParcelServices.php 2020-02-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Interfaces;

use IteratorAggregate;
use JsonSerializable;

/**
 * Interface ParcelServices
 *
 * @package Gambio\Admin\ParcelService\Interfaces
 */
interface ParcelServices extends IteratorAggregate, JsonSerializable
{
    /**
     * Returns internal parcel services as an array.
     *
     * @return ParcelService[]
     */
    public function items(): array;
    
    
    /**
     * @inheritDoc
     *
     * @return ParcelService[]
     */
    public function jsonSerialize(): array;
}